# FZ-M1 Optimizer

Aplicatie Python pentru optimizarea tabletei Panasonic FZ-M1 (Windows 10 IoT Enterprise LTSC).

## Functionalitati
- Diagnoza sistem, procese si servicii
- Curatare rapida: temp, cache, prefetch, Windows Update
- Management servicii si planuri de alimentare
- Tweaks Windows (vizuale, background apps, telemetrie)
- Log-uri salvate automat

## Cerinte
- Windows 10
- Python 3.10+
- Drepturi de administrator pentru schimbari de sistem

Instaleaza dependentele:

```powershell
python -m venv .venv
.venv\Scripts\Activate.ps1
pip install -r requirements.txt
```

Ruleaza aplicatia:

```powershell
python -m src.main
```

### Creare executabil
Instaleaza PyInstaller (daca nu exista):

```powershell
pip install pyinstaller
```

Construieste executabilul standalone:

```powershell
pyinstaller --noconfirm --clean --windowed --name FZ-M1-Optimizer --add-data "src\optimizer;optimizer" src\main.py
```

Executabilul il vei gasi in `dist\FZ-M1-Optimizer\FZ-M1-Optimizer.exe`. Copiaza tot folderul `dist\FZ-M1-Optimizer` pe tableta si ruleaza `.exe`.
